<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Login - Harris Absensi</title>

    <script src="https://cdn.tailwindcss.com"></script>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap');

        * {
            font-family: 'Poppins', sans-serif;
        }

        html,
        body {
            height: 100%;
            overflow: hidden;
            position: fixed;
            width: 100%;
        }

        body {
            background: linear-gradient(135deg, #ffffff 0%, #fff5f0 100%);
        }

        .container-wrapper {
            height: 100vh;
            height: 100dvh;
            /* Dynamic viewport height for mobile */
            overflow: hidden;
        }

        .gradient-bg {
            background: linear-gradient(135deg, #FF6B35 0%, #FF8C42 100%);
        }

        .gradient-text {
            background: linear-gradient(135deg, #FF6B35 0%, #FF8C42 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .input-field {
            transition: all 0.3s ease;
            border: 2px solid #f0f0f0;
        }

        .input-field:focus {
            border-color: #FF6B35;
            box-shadow: 0 0 0 4px rgba(255, 107, 53, 0.1);
        }

        .btn-primary {
            background: linear-gradient(135deg, #FF6B35 0%, #FF8C42 100%);
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(255, 107, 53, 0.3);
        }

        .btn-primary:active {
            transform: translateY(0);
        }

        .captcha-container {
            position: relative;
            overflow: hidden;
            border-radius: 12px;
            border: 2px solid #f0f0f0;
        }

        .captcha-image {
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .captcha-image:hover {
            opacity: 0.8;
        }

        .floating-shape {
            position: absolute;
            border-radius: 50%;
            opacity: 0.1;
            animation: float 20s infinite ease-in-out;
        }

        @keyframes float {

            0%,
            100% {
                transform: translate(0, 0) rotate(0deg);
            }

            33% {
                transform: translate(30px, -30px) rotate(120deg);
            }

            66% {
                transform: translate(-30px, 30px) rotate(240deg);
            }
        }

        .shape-1 {
            width: 300px;
            height: 300px;
            background: #FF6B35;
            top: -100px;
            right: -100px;
        }

        .shape-2 {
            width: 200px;
            height: 200px;
            background: #FF8C42;
            bottom: -50px;
            left: -50px;
            animation-delay: -5s;
        }

        .logo-container {
            position: relative;
            display: inline-block;
        }

        .logo-text {
            font-weight: 800;
            font-size: 3rem;
            letter-spacing: -2px;
        }

        @media (max-width: 640px) {
            .logo-text {
                font-size: 2rem;
            }
        }
    </style>
</head>

<body class="overflow-hidden">
    <!-- Floating Shapes -->
    <div class="floating-shape shape-1"></div>
    <div class="floating-shape shape-2"></div>

    <div class="container-wrapper flex items-center justify-center p-2 sm:p-4 relative z-10">
        <div class="w-full max-w-6xl h-full flex items-center">
            <div class="grid lg:grid-cols-2 gap-4 lg:gap-8 items-center w-full max-h-full overflow-hidden">

                <!-- Left Side ((dekstop) -->
                <div class="hidden lg:flex flex-col justify-center space-y-8 p-8">
                    <div class="space-y-4">
                        <div class="logo-container flex justify-center">
                            <img src="{{ asset('img/Logo.png') }}" alt="HARRIS Hotel Logo"
                                class="h-32 object-contain">
                        </div>
                    </div>


                    <div class="space-y-6">
                        <h2 class="text-4xl font-bold text-gray-800">
                            Sistem Absensi<br />
                            <span class="gradient-text">Karyawan</span>
                        </h2>
                        <p class="text-lg text-gray-600">
                            Absensi mudah dengan teknologi face recognition dan GPS tracking
                        </p>
                    </div>

                </div>

                <!-- Right Side - Login Form -->
                <div class="w-full max-h-full overflow-y-auto overflow-x-hidden">
                    <div class="bg-white rounded-2xl lg:rounded-3xl shadow-2xl p-4 sm:p-8 lg:p-12">

                        <!-- Mobile Logo -->
                        <div class="lg:hidden text-center mb-4">
                                                <div class="space-y-4">
                        <div class="logo-container flex justify-center">
                            <img src="{{ asset('img/Logo.png') }}" alt="HARRIS Hotel Logo"
                                class="h-32 object-contain">
                        </div>
                    </div>
                        </div>

                        <!-- Header -->
                        <div class="text-center mb-4 sm:mb-8">
                            <h2 class="text-2xl sm:text-3xl font-bold text-gray-800 mb-1 sm:mb-2">Sign In</h2>
                            <p class="text-sm text-gray-600">Masuk dengan akun Anda</p>
                        </div>

                        <!-- Error Messages -->
                        @if ($errors->any())
                            <div class="mb-4 bg-red-50 border-l-4 border-red-500 p-3 rounded-lg">
                                <div class="flex items-start">
                                    <svg class="w-4 h-4 text-red-500 mt-0.5 mr-2 flex-shrink-0" fill="currentColor"
                                        viewBox="0 0 20 20">
                                        <path fill-rule="evenodd"
                                            d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                            clip-rule="evenodd"></path>
                                    </svg>
                                    <div class="flex-1">
                                        <p class="text-xs font-semibold text-red-800 mb-1">Terjadi Kesalahan:</p>
                                        <ul class="text-xs text-red-700 space-y-1">
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        @endif

                        <!-- Login Form -->
                        <form action="{{ route('login.post') }}" method="POST" id="loginForm">
                            @csrf

                            <!-- Email -->
                            <div class="mb-4">
                                <label for="email" class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                                    Email Address
                                </label>
                                <div class="relative">
                                    <div
                                        class="absolute inset-y-0 left-0 pl-3 sm:pl-4 flex items-center pointer-events-none">
                                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-gray-400" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207">
                                            </path>
                                        </svg>
                                    </div>
                                    <input type="email" id="email" name="email" value="{{ old('email') }}"
                                        required
                                        class="input-field w-full pl-10 sm:pl-12 pr-4 py-2.5 sm:py-3.5 rounded-xl outline-none text-gray-800 text-sm sm:text-base"
                                        placeholder="nama@email.com" autocomplete="email">
                                </div>
                            </div>

                            <!-- Password -->
                            <div class="mb-4">
                                <label for="password" class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                                    Password
                                </label>
                                <div class="relative">
                                    <div
                                        class="absolute inset-y-0 left-0 pl-3 sm:pl-4 flex items-center pointer-events-none">
                                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-gray-400" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                                            </path>
                                        </svg>
                                    </div>
                                    <input type="password" id="password" name="password" required
                                        class="input-field w-full pl-10 sm:pl-12 pr-10 sm:pr-12 py-2.5 sm:py-3.5 rounded-xl outline-none text-gray-800 text-sm sm:text-base"
                                        placeholder="Masukkan password" autocomplete="current-password">
                                    <button type="button" onclick="togglePassword()"
                                        class="absolute inset-y-0 right-0 pr-3 sm:pr-4 flex items-center text-gray-400 hover:text-gray-600">
                                        <svg id="eye-icon" class="w-4 h-4 sm:w-5 sm:h-5" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                            </path>
                                        </svg>
                                    </button>
                                </div>
                            </div>

                            <!-- CAPTCHA -->
                            <div class="mb-4">
                                <label for="captcha"
                                    class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                                    Security Code
                                </label>

                                <div class="flex items-center gap-2 sm:gap-3 mb-2 sm:mb-3">
                                    <div class="captcha-container flex-shrink-0">
                                        <img src="{{ route('captcha') }}" alt="CAPTCHA" id="captcha-image"
                                            class="captcha-image h-12 sm:h-14 w-auto bg-gray-50"
                                            onclick="refreshCaptcha()" title="Klik untuk refresh">
                                    </div>
                                    <button type="button" onclick="refreshCaptcha()"
                                        class="p-2 sm:p-3 bg-gray-100 hover:bg-gray-200 rounded-xl transition"
                                        title="Refresh CAPTCHA">
                                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-gray-600" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15">
                                            </path>
                                        </svg>
                                    </button>
                                </div>

                                <input type="text" id="captcha" name="captcha" required maxlength="6"
                                    class="input-field w-full px-3 sm:px-4 py-2.5 sm:py-3.5 rounded-xl outline-none text-gray-800 text-sm sm:text-base"
                                    placeholder="Masukkan kode di atas" autocomplete="off">
                                <p class="text-xs text-gray-500 mt-1 sm:mt-2 flex items-start">
                                    <svg class="w-3 h-3 sm:w-4 sm:h-4 mr-1 mt-0.5 flex-shrink-0" fill="currentColor"
                                        viewBox="0 0 20 20">
                                        <path fill-rule="evenodd"
                                            d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"
                                            clip-rule="evenodd"></path>
                                    </svg>
                                    <span class="text-xs">Ketik kode keamanan (tidak case-sensitive)</span>
                                </p>
                            </div>

                            <!-- Submit Button -->
                            <button type="submit"
                                class="btn-primary w-full text-white py-3 sm:py-4 rounded-xl font-semibold text-base sm:text-lg shadow-lg">
                                Sign In
                            </button>
                        </form>

                        <!-- Demo Info -->
                        {{-- <div class="mt-4 sm:mt-8 p-3 sm:p-4 bg-orange-50 rounded-xl border border-orange-200">
                            <p class="text-xs font-semibold text-orange-800 mb-1 sm:mb-2 flex items-center">
                                <svg class="w-3 h-3 sm:w-4 sm:h-4 mr-1 flex-shrink-0" fill="currentColor"
                                    viewBox="0 0 20 20">
                                    <path fill-rule="evenodd"
                                        d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"
                                        clip-rule="evenodd"></path>
                                </svg>
                                Demo:
                            </p>
                            <div class="space-y-1 text-xs text-orange-700">
                                <p><span class="font-semibold">Admin:</span> admin@gmail.com / 123</p>
                                <p><span class="font-semibold">Karyawan:</span> karyawan@gmail.com / password</p>
                            </div>
                        </div> --}}
                        <!-- Register Link -->
                        <div class="mt-4 sm:mt-6 text-center">
                            <p class="text-sm text-gray-600">
                                Belum punya akun?
                                <a href="{{ route('register') }}"
                                    class="font-semibold text-orange-600 hover:text-orange-700">
                                    Daftar di sini
                                </a>
                            </p>
                        </div>
                        <!-- Footer -->
                        {{-- <div class="mt-4 sm:mt-8 text-center">
                            <p class="text-xs sm:text-sm text-gray-500">
                                © 2025 Harris Hotel Bandung
                            </p>
                        </div> --}}
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script>
        // Toggle password visibility
        function togglePassword() {
            const passwordInput = document.getElementById('password');
            const eyeIcon = document.getElementById('eye-icon');

            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                eyeIcon.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"></path>
                `;
            } else {
                passwordInput.type = 'password';
                eyeIcon.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                `;
            }
        }

        // Refresh CAPTCHA
        function refreshCaptcha() {
            const captchaImage = document.getElementById('captcha-image');
            const captchaInput = document.getElementById('captcha');

            captchaImage.src = '{{ route('captcha') }}?' + Date.now();
            captchaInput.value = '';
            captchaInput.focus();

            captchaImage.style.opacity = '0.5';
            setTimeout(() => {
                captchaImage.style.opacity = '1';
            }, 200);
        }

        // Auto-refresh CAPTCHA on error
        @if ($errors->has('captcha'))
            refreshCaptcha();
        @endif

        // Auto-focus on first input with error
        window.addEventListener('load', function() {
            @if ($errors->has('email'))
                document.getElementById('email').focus();
            @elseif ($errors->has('password'))
                document.getElementById('password').focus();
            @elseif ($errors->has('captcha'))
                document.getElementById('captcha').focus();
            @endif
        });
    </script>
</body>

</html>
